#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:036*/
layout(location = 0) out vec4 sceneColor;
layout(location = 1) out vec4 lightmapData;
layout(location = 2) out vec3 filterAux;

#include "/lib/head.glsl"
#include "/lib/util/encoders.glsl"

const int noiseTextureResolution = 256;

in vec2 coord;

flat in mat2x3 lightColor;
flat in vec3 sky_color;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex1;

uniform sampler2D noisetex;

uniform int frameCounter;

uniform float aspectRatio;
uniform float far, near;

uniform vec2 viewSize, pixelSize;
uniform vec2 taaOffset;

uniform mat4 gbufferModelView, gbufferModelViewInverse;
uniform mat4 gbufferProjection, gbufferProjectionInverse;

/* ------ includes ------ */
#define FUTIL_LINDEPTH
#define FUTIL_D3X3
#include "/lib/fUtil.glsl"

#include "/lib/frag/bluenoise.glsl"
#include "/lib/util/transforms.glsl"


/* ------ ambient occlusion and gi ------ */
#include "/lib/light/ao.glsl"

void main() {
        sceneColor   = stex(colortex0);
    float sceneDepth = stex(depthtex1).x;

    if (!landMask(sceneDepth)) {
        sceneColor.rgb = sky_color;
    }

    lightmapData    = vec4(0.0);
    filterAux       = vec3(0.0);

    #ifdef lightmapSmoothingEnabled
    if (landMask(sceneDepth)) {
        vec4 tex1   = stex(colortex1);
        lightmapData.xyz = vec3(decode2x8(tex1.z), sceneColor.a);
        filterAux     = decodeNormal(tex1.xy) * 0.5 + 0.5;
    }
    #endif

    #ifdef ambientOcclusionEnabled
        vec2 ao_coord   = (coord)*2.0;

        if (clamp(ao_coord, -0.003, 1.003) == ao_coord) {
            vec2 coord  = ao_coord;
            float d     = depthMax3x3(depthtex1, ao_coord, pixelSize*sqrt(2.0));

            if (landMask(d)) {
                float sceneDepth = stex(depthtex1).x;
                vec4 tex1       = stex(colortex1);

                vec3 sceneNormal = decodeNormal(tex1.xy);
                vec3 viewnormal = normalize(mat3(gbufferModelView) * sceneNormal);

                #ifdef directionalSSAO
                    float ao    = getDSSAO(depthtex1, sceneNormal, sceneDepth, coord, ditherBluenoise());
                #else
                    float ao    = getSSAO(depthtex1, sceneDepth, coord, ditherBluenoise());
                #endif

                lightmapData.w   = ao;
            } else {
                lightmapData.w   = 1.0;
            }
        }
    #endif

    sceneColor      = makeDrawbuffer(sceneColor);
    lightmapData    = clamp16F(lightmapData);
    filterAux       = clamp16F(filterAux);
}